#ifndef TYPES_H
#define TYPES_H
typedef unsigned char u8;
typedef unsigned int u16;
typedef unsigned long int u32;

typedef struct 
{
	unsigned char	TAAC;
	unsigned char	NSAC;
	unsigned char 	TRAN_SPEED;
	unsigned int	CCC;
	unsigned char	READ_BL_LEN;
	unsigned long	C_SIZE;
	unsigned char	C_SIZE_MULT;
	unsigned char	SECTOR_SIZE;
	unsigned char	FILE_FORMAT;
} CSD_REGISTER;

typedef struct
{
	unsigned char	MID;		// Manufacturer ID
	unsigned int	OID;		// OEM ID
	unsigned char 	PNM[7];		// Product Name
	unsigned char	PRV;		// Product Revision
	unsigned char	PSN[4];		// Serial Number
	unsigned int	MDT;		// Manufacture Date M/Y from 2000
} CID_REGISTER;

typedef struct
{
	unsigned char	OCR[4];
} OCR_REGISTER;

typedef struct
{
	unsigned char		CARD_TYPE;		// 0: not SD/MMC, 1: MMC , 2: SD v1 4: SD v2 6: SDHC
	unsigned char		VOLTAGE_RANGE;	// 0: not supported 1: supported (3.3V)
	unsigned long long	SIZE;			// size in Bytes (filled in when CSD is read)
	unsigned char	ERROR;				// 0: no errors >0: errors
	CID_REGISTER	cid;				// CID Register
	CSD_REGISTER	csd;				// CSD Register
	OCR_REGISTER	ocr;				// OCR Register
} CARD_INFO;

#endif
